#
#VID 37a365ed-1269-11de-a964-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 37a365ed-1269-11de-a964-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63626);
 script_cve_id("CVE-2009-0386", "CVE-2009-0387", "CVE-2009-0397");
 script_version ("$");
 name = "FreeBSD Ports: gstreamer-plugins-good";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gstreamer-plugins-good

CVE-2009-0386
Heap-based buffer overflow in the qtdemux_parse_samples function in
gst/qtdemux/qtdemux.c in GStreamer Good Plug-ins (aka
gst-plugins-good) 0.10.9 through 0.10.11 might allow remote attackers
to execute arbitrary code via crafted Composition Time To Sample
(ctts) atom data in a malformed QuickTime media .mov file.

CVE-2009-0387
Array index error in the qtdemux_parse_samples function in
gst/qtdemux/qtdemux.c in GStreamer Good Plug-ins (aka
gst-plugins-good) 0.10.9 through 0.10.11 allows remote attackers to
cause a denial of service (application crash) and possibly execute
arbitrary code via crafted Sync Sample (aka stss) atom data in a
malformed QuickTime media .mov file, related to 'mark keyframes.'

CVE-2009-0397
Heap-based buffer overflow in the qtdemux_parse_samples function in
gst/qtdemux/qtdemux.c in GStreamer Good Plug-ins (aka
gst-plugins-good) 0.10.9 through 0.10.11, and GStreamer Plug-ins (aka
gstreamer-plugins) 0.8.5, might allow remote attackers to execute
arbitrary code via crafted Time-to-sample (aka stts) atom data in a
malformed QuickTime media .mov file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/33650/
http://trapkit.de/advisories/TKADV2009-003.txt
http://gstreamer.freedesktop.org/releases/gst-plugins-good/0.10.12.html
http://www.vuxml.org/freebsd/37a365ed-1269-11de-a964-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gstreamer-plugins-good";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gstreamer-plugins-good");
if(!isnull(bver) && revcomp(a:bver, b:"0.10.9,3")>=0 && revcomp(a:bver, b:"0.10.12,3")<0) {
    security_note(0, data:"Package gstreamer-plugins-good version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
