#
#VID 72da8af6-7c75-11d9-8cc5-000854d03344
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52193);
 script_cve_id("CVE-2004-1184", "CVE-2004-1185", "CVE-2004-1186");
 script_version ("$");
 name = "FreeBSD Ports: enscript-a4, enscript-letter, enscript-letterdj";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   enscript-a4
   enscript-letter
   enscript-letterdj

CVE-2004-1184
The EPSF pipe support in enscript 1.6.3 allows remote attackers or
local users to execute arbitrary commands via shell metacharacters.

CVE-2004-1185
Enscript 1.6.3 does not sanitize filenames, which allows remote
attackers or local users to execute arbitrary commands via crafted
filenames.

CVE-2004-1186
Multiple buffer overflows in enscript 1.6.3 allow remote attackers or
local users to cause a denial of service (application crash).

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.gentoo.org/security/en/glsa/glsa-200502-03.xml
http://www.vuxml.org/freebsd/72da8af6-7c75-11d9-8cc5-000854d03344.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: enscript-a4, enscript-letter, enscript-letterdj";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"enscript-a4");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.4_1")<0) {
    security_note(0, data:"Package enscript-a4 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"enscript-letter");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.4_1")<0) {
    security_note(0, data:"Package enscript-letter version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"enscript-letterdj");
if(!isnull(bver) && revcomp(a:bver, b:"1.6.4_1")<0) {
    security_note(0, data:"Package enscript-letterdj version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
