#
#VID 66657bd5-ac92-11dd-b541-001f3b19d541
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 66657bd5-ac92-11dd-b541-001f3b19d541
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61876);
 script_version ("$");
 name = "FreeBSD Ports: emacs";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: emacs

Solution:
Update your system with the appropriate patches or
software upgrades.

http://lists.gnu.org/archive/html/emacs-devel/2008-09/msg00215.html
http://www.vuxml.org/freebsd/66657bd5-ac92-11dd-b541-001f3b19d541.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: emacs";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"emacs");
if(!isnull(bver) && revcomp(a:bver, b:"22.2_1")<=0) {
    security_note(0, data:"Package emacs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
