#
#VID b4892b5b-fb1c-11d9-96ba-00909925db3e
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54425);
 script_cve_id("CVE-2005-1202", "CVE-2005-1203");
 script_version ("$");
 name = "FreeBSD Ports: egroupware";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: egroupware

CVE-2005-1202
Multiple cross-site scripting (XSS) vulnerabilities in eGroupware
before 1.0.0.007 allow remote attackers to inject arbitrary web script
or HTML via the (1) ab_id, (2) page, (3) type, or (4) lang parameter
to index.php or (5) category_id parameter.

CVE-2005-1203
Multiple SQL injection vulnerabilities in index.php in eGroupware
before 1.0.0.007 allow remote attackers to execute arbitrary SQL
commands via the (1) filter or (2) cats_app parameter.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://sourceforge.net/project/shownotes.php?release_id=320768
http://www.vuxml.org/freebsd/b4892b5b-fb1c-11d9-96ba-00909925db3e.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: egroupware";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"egroupware");
if(!isnull(bver) && revcomp(a:bver, b:"1.0.0.007")<0) {
    security_note(0, data:"Package egroupware version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
