#
#VID 40a0185f-ec32-11da-be02-000c6ec775d9
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56889);
 script_cve_id("CVE-2006-2742", "CVE-2006-2743");
 script_version ("$");
 name = "FreeBSD Ports: drupal";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: drupal

CVE-2006-2742
SQL injection vulnerability in Drupal 4.6.x before 4.6.7 and 4.7.0
allows remote attackers to execute arbitrary SQL commands via the (1)
count and (2) from variables to (a) database.mysql.inc, (b)
database.pgsql.inc, and (c) database.mysqli.inc.

CVE-2006-2743
Drupal 4.6.x before 4.6.7 and 4.7.0, when running on Apache with
mod_mime, does not properly handle files with multiple extensions,
which allows remote attackers to upload, modify, or execute arbitrary
files in the files directory.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://drupal.org/node/65357
http://drupal.org/node/65409
http://www.vuxml.org/freebsd/40a0185f-ec32-11da-be02-000c6ec775d9.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: drupal";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"drupal");
if(!isnull(bver) && revcomp(a:bver, b:"4.6.7")<0) {
    security_note(0, data:"Package drupal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
