#
#VID 83725c91-7c7e-11de-9672-00e0815b8da8
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 83725c91-7c7e-11de-9672-00e0815b8da8
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64580);
 script_cve_id("CVE-2009-0696");
 script_version ("$");
 script_name("FreeBSD Ports: bind9");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   bind9
   bind9-sdb-postgresql
   bind9-sdb-ldap

CVE-2009-0696
The dns_db_findrdataset function in db.c in named in ISC BIND 9.4
before 9.4.3-P3, 9.5 before 9.5.1-P3, and 9.6 before 9.6.1-P1, when
configured as a master server, allows remote attackers to cause a
denial of service (assertion failure and daemon exit) via an ANY
record in the prerequisite section of a crafted dynamic update
message, as exploited in the wild in July 2009.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.kb.cert.org/vuls/id/725188
https://www.isc.org/node/474
http://www.vuxml.org/freebsd/83725c91-7c7e-11de-9672-00e0815b8da8.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: bind9");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bind9");
if(!isnull(bver) && revcomp(a:bver, b:"9.3.6.1.1")<0) {
    security_note(0, data:"Package bind9 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"bind9-sdb-postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"9.4.3.3")<0) {
    security_note(0, data:"Package bind9-sdb-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"bind9-sdb-ldap");
if(!isnull(bver) && revcomp(a:bver, b:"9.4.3.3")<0) {
    security_note(0, data:"Package bind9-sdb-ldap version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
