#
#VID 947f4b14-1c89-11da-bc01-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55221);
 script_bugtraq_id(12364);
 script_cve_id("CVE-2005-0033");
 script_version ("$");
 name = "FreeBSD Ports: bind";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: bind

CVE-2005-0033
Buffer overflow in the code for recursion and glue fetching in BIND
8.4.4 and 8.4.5 allows remote attackers to cause a denial of service
(crash) via queries that trigger the overflow in the q_usedns array
that tracks nameservers and addresses.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.uniras.gov.uk/niscc/docs/al-20050125-00059.html?lang=en
http://www.isc.org/sw/bind/bind-security.php
http://www.vuxml.org/freebsd/947f4b14-1c89-11da-bc01-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: bind";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"bind");
if(!isnull(bver) && revcomp(a:bver, b:"8.4.4")>=0 && revcomp(a:bver, b:"8.4.6")<0) {
    security_note(0, data:"Package bind version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
