#
#VID 8471bb85-6fb0-11d8-873f-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52494);
 script_cve_id("CVE-2004-0353", "CVE-2004-0354");
 script_bugtraq_id(9772);
 script_version ("$");
 name = "FreeBSD Ports: anubis";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: anubis

CVE-2004-0353
Multiple buffer overflows in auth_ident() function in auth.c for GNU
Anubis 3.6.0 through 3.6.2, 3.9.92 and 3.9.93 allow remote attackers
to gain privileges via a long string.

CVE-2004-0354
Multiple format string vulnerabilities in GNU Anubis 3.6.0 through
3.6.2, 3.9.92 and 3.9.93 allow remote attackers to execute arbitrary
code via format string specifiers in strings passed to (1) the info
function in log.c, (2) the anubis_error function in errs.c, or (3) the
ssl_error function in ssl.c.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://lists.netsys.com/pipermail/full-disclosure/2004-March/018290.html
http://www.vuxml.org/freebsd/8471bb85-6fb0-11d8-873f-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: anubis";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"anubis");
if(!isnull(bver) && revcomp(a:bver, b:"3.6.2_1")<=0) {
    security_note(0, data:"Package anubis version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
