#
#VID 78348ea2-ec91-11d8-b913-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52425);
 script_bugtraq_id(10931);
 script_cve_id("CVE-2004-0630");
 script_version ("$");
 name = "FreeBSD Ports: acroread, acroread4, acroread5";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   acroread
   acroread4
   acroread5

CVE-2004-0630
The uudecoding feature in Adobe Acrobat Reader 5.0.5 and 5.0.6 for
Unix and Linux, and possibly other versions including those before
5.0.9, allows remote attackers to execute arbitrary code via shell
metacharacters ('`' or backtick) in the filename of the PDF file that
is provided to the uudecode command.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.idefense.com/application/poi/display?id=124&type=vulnerabilities
http://www.vuxml.org/freebsd/78348ea2-ec91-11d8-b913-000c41e2cdad.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: acroread, acroread4, acroread5";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"acroread");
if(!isnull(bver) && revcomp(a:bver, b:"5.0.9")<0) {
    security_note(0, data:"Package acroread version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"acroread4");
if(!isnull(bver) && revcomp(a:bver, b:"5.0.9")<0) {
    security_note(0, data:"Package acroread4 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"acroread5");
if(!isnull(bver) && revcomp(a:bver, b:"5.0.9")<0) {
    security_note(0, data:"Package acroread5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
