#
#VID fbc8413f-2f7a-11de-9a3f-001b77d09812
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID fbc8413f-2f7a-11de-9a3f-001b77d09812
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63968);
 script_cve_id("CVE-2009-0590");
 script_version ("$");
 name = "FreeBSD Ports: FreeBSD";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: FreeBSD

CVE-2009-0590
The ASN1_STRING_print_ex function in OpenSSL before 0.9.8k allows
remote attackers to cause a denial of service (invalid memory access
and application crash) via vectors that trigger printing of a (1)
BMPString or (2) UniversalString with an invalid encoded length.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: FreeBSD";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"FreeBSD");
if(!isnull(bver) && revcomp(a:bver, b:"6.3")>=0 && revcomp(a:bver, b:"6.3_10")<0) {
    security_note(0, data:"Package FreeBSD version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"6.4")>=0 && revcomp(a:bver, b:"6.4_4")<0) {
    security_note(0, data:"Package FreeBSD version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.0")>=0 && revcomp(a:bver, b:"7.0_12")<0) {
    security_note(0, data:"Package FreeBSD version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.1")>=0 && revcomp(a:bver, b:"7.1_5")<0) {
    security_note(0, data:"Package FreeBSD version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
