# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9675 (xmp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64962);
 script_cve_id("CVE-2007-6731", "CVE-2007-6732");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-9675 (xmp)");

 desc = "The remote host is missing an update to xmp
announced via advisory FEDORA-2009-9675.

Update Information:

Update to latest stable release. Multiple bugfixes and memory leak fixes. Fixes
for buffer overflows in DTT and OXM loaders.

ChangeLog:

* Mon Sep 14 2009 Dominik Mierzejewski  2.7.1-1
- updated to 2.7.1
- fixes CVE-2007-6731 (rhbz#523138) and CVE-2007-6732 (rhbz#523147)

References:

[ 1 ] Bug #523138 - CVE-2007-6731 xmp: Multiple buffer overflows in OXM decoder
https://bugzilla.redhat.com/show_bug.cgi?id=523138
[ 2 ] Bug #523147 - CVE-2007-6732 xmp: Buffer overflow in DTT file loader
https://bugzilla.redhat.com/show_bug.cgi?id=523147

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xmp' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9675

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-9675 (xmp)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"audacious-plugin-xmp", rpm:"audacious-plugin-xmp~2.7.1~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xmms-xmp", rpm:"xmms-xmp~2.7.1~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xmp", rpm:"xmp~2.7.1~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xmp-debuginfo", rpm:"xmp-debuginfo~2.7.1~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
