# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9652 (nginx)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64912);
 script_cve_id("CVE-2009-2629");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-9652 (nginx)");

 desc = "The remote host is missing an update to nginx
announced via advisory FEDORA-2009-9652.

ChangeLog:

* Mon Sep 14 2009 Jeremy Hinegardner  - 0.7.62-1
- update to 0.7.62
- fixes CVE-2009-2629
* Sun Aug  2 2009 Jeremy Hinegardner  - 0.7.61-1
- update to new stable 0.7.61
- remove third party module

References:

[ 1 ] Bug #523105 - CVE-2009-2629 nginx: ngx_http_parse_complex_uri() buffer underflow vulnerability (VU#180065)
https://bugzilla.redhat.com/show_bug.cgi?id=523105

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update nginx' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9652

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-9652 (nginx)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"nginx", rpm:"nginx~0.7.62~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nginx-debuginfo", rpm:"nginx-debuginfo~0.7.62~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
