# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9494 (epiphany)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64854);
 script_cve_id("CVE-2009-3070", "CVE-2009-3071", "CVE-2009-3072", "CVE-2009-3074", "CVE-2009-3075", "CVE-2009-3076", "CVE-2009-3077", "CVE-2009-3078", "CVE-2009-3079");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-9494 (epiphany)");

 desc = "The remote host is missing an update to epiphany
announced via advisory FEDORA-2009-9494.

Update Information:

Update to new upstream Firefox version 3.0.14, fixing multiple security issues
detailed in the upstream advisories:
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.14

Update also includes all packages depending on gecko-libs rebuilt
against new version of Firefox / XULRunner.

ChangeLog:

* Wed Sep  9 2009 Jan Horak  - 2.24.3-10
- Rebuild against newer gecko

References:

[ 1 ] Bug #521686 - CVE-2009-3070 Firefox 3.5 3.0.14 browser engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=521686
[ 2 ] Bug #521687 - CVE-2009-3071 Firefox 3.5.2 3.0.14 browser engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=521687
[ 3 ] Bug #521688 - CVE-2009-3072 Firefox 3.5.3 3.0.14 browser engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=521688
[ 4 ] Bug #521690 - CVE-2009-3074 Firefox 3.5 3.0.14 JavaScript engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=521690
[ 5 ] Bug #521691 - CVE-2009-3075 Firefox 3.5.2 3.0.14 JavaScript engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=521691
[ 6 ] Bug #521692 - CVE-2009-3076 Firefox 3.0.14 Insufficient warning for PKCS11 module installation and removal
https://bugzilla.redhat.com/show_bug.cgi?id=521692
[ 7 ] Bug #521693 - CVE-2009-3077 Firefox 3.5.3 3.0.14 TreeColumns dangling pointer vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=521693
[ 8 ] Bug #521694 - CVE-2009-3078 Firefox 3.5.3 3.0.14 Location bar spoofing via tall line-height Unicode characters
https://bugzilla.redhat.com/show_bug.cgi?id=521694
[ 9 ] Bug #521695 - CVE-2009-3079 Firefox 3.5.3 3.0.14 Chrome privilege escalation with FeedWriter
https://bugzilla.redhat.com/show_bug.cgi?id=521695

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update epiphany' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9494

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-9494 (epiphany)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"epiphany", rpm:"epiphany~2.24.3~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"epiphany-devel", rpm:"epiphany-devel~2.24.3~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"epiphany-debuginfo", rpm:"epiphany-debuginfo~2.24.3~10.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
