# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-9391 (kdelibs3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64844);
 script_cve_id("CVE-2009-2702", "CVE-2009-2537", "CVE-2009-1725", "CVE-2009-1690", "CVE-2009-1687", "CVE-2009-1698");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-9391 (kdelibs3)");

 desc = "The remote host is missing an update to kdelibs3
announced via advisory FEDORA-2009-9391.

Update Information:

This update fixes CVE-2009-2702, a security issue where SSL certificates
containing embedded NUL characters would falsely pass validation when they're
actually invalid, for the KDE 3 compatibility version of kdelibs.

ChangeLog:

* Sun Sep  6 2009 Kevin Kofler  - 3.5.10-13.1
- fix for CVE-2009-2702

References:

[ 1 ] Bug #520661 - CVE-2009-2702 kdelibs: kssl incorrect verification of SSL certificate with NUL in subjectAltName
https://bugzilla.redhat.com/show_bug.cgi?id=520661

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update kdelibs3' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-9391

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-9391 (kdelibs3)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"kdelibs3", rpm:"kdelibs3~3.5.10~13.fc11.1", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs3-devel", rpm:"kdelibs3-devel~3.5.10~13.fc11.1", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs3-debuginfo", rpm:"kdelibs3-debuginfo~3.5.10~13.fc11.1", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kdelibs3-apidocs", rpm:"kdelibs3-apidocs~3.5.10~13.fc11.1", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
