# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8529 (wordpress-mu)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64697);
 script_cve_id("CVE-2009-2334", "CVE-2009-2335", "CVE-2009-2336");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8529 (wordpress-mu)");

 desc = "The remote host is missing an update to wordpress-mu
announced via advisory FEDORA-2009-8529.

Update spans MU-versions for the following security releases from upstream:

http://wordpress.org/development/2009/08/2-8-4-security-release/
http://wordpress.org/development/2009/08/wordpress-2-8-3-security-release/

* Backport of XSS fixes from WordPress 2.8.2
* Backport of security fixes for admin.php?page= bugs (CVE-2009-2334)

ChangeLog:

* Wed Aug 12 2009 Bret McMillan  - 2.8.4a-1
- Update to version 2.8.4a for security fixes
* Fri Jul 10 2009 Bret McMillan  - 2.7-6
- Patch for CVE-2009-2334

References:

[ 1 ] Bug #510745 - CVE-2009-2334, CVE-2009-2335, CVE-2009-2336  wordpress: multiple vulnerabilities
https://bugzilla.redhat.com/show_bug.cgi?id=510745

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wordpress-mu' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8529

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8529 (wordpress-mu)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wordpress-mu", rpm:"wordpress-mu~2.8.4a~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
