# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8501 (viewvc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64628);
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-8501 (viewvc)");

 desc = "The remote host is missing an update to viewvc
announced via advisory FEDORA-2009-8501.

Update Information:

CHANGES in 1.0.9:
- security fix: validate the 'view' parameter to avoid XSS attack
- security fix: avoid printing illegal parameter names and values
Also includes:
Patch by Patrick Monnerat to make allow_tar work on F-10.

ChangeLog:

* Wed Aug 12 2009 Bojan Smojver  - 1.0.9-1
- bump up to 1.0.9
- security fix: validate the 'view' parameter to avoid XSS attack
- security fix: avoid printing illegal parameter names and values
* Tue Aug 11 2009 Bojan Smojver  - 1.0.8-2
- fix allow_tar
- patch by Patrick Monnerat

References:

[ 1 ] Bug #513006 - allow_tar option does not work
https://bugzilla.redhat.com/show_bug.cgi?id=513006

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update viewvc' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8501

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8501 (viewvc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"viewvc", rpm:"viewvc~1.0.9~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"viewvc-httpd", rpm:"viewvc-httpd~1.0.9~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
