# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8270 (ghostscript)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64709);
 script_cve_id("CVE-2009-0583");
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8270 (ghostscript)");

 desc = "The remote host is missing an update to ghostscript
announced via advisory FEDORA-2009-8270.

Update Information:

This updates ghostscript to the latest stable release.
ChangeLog:

* Mon Aug  3 2009 Tim Waugh  8.70-1
- 8.70.
- License has changed to GPLv3+.  Packages containing programs that
link to libgs/libijs are:
- foomatic (GPLv2+)
- libspectre (GPLv2+)
- ImageMagick (ImageMagick, listed on Licensing wiki page under
Good Licenses and marked as GPLv3 compat)
- gutenprint (GPLv2+)
* Mon Aug  3 2009 Tim Waugh  8.64-12
- Moved examples to doc subpackage (bug #515167).
- Converted spec file to UTF-8.

References:

[ 1 ] Bug #503992 - Ghostscript: Multiple NULL pointer dereferences in JBIG2 decoder [F11]
https://bugzilla.redhat.com/show_bug.cgi?id=503992

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ghostscript' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8270

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8270 (ghostscript)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.70~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.70~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-doc", rpm:"ghostscript-doc~8.70~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~8.70~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~8.70~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
