# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8184 (drupal-date)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64547);
 script_version ("$");
 script_name("Fedora Core 11 FEDORA-2009-8184 (drupal-date)");

 desc = "The remote host is missing an update to drupal-date
announced via advisory FEDORA-2009-8184.

The Date API is available to be used by other modules and is not dependent
on having CCK installed.  The date module is a flexible date/time field
type for the cck content module which requires the CCK content.module and
the Date API module.

Update Information:

* Advisory ID: DRUPAL-SA-CONTRIB-2009-046
* Project: Date (third-party module)
* Version: 6.x
* Date: 2009-July-29
* Security risk: Moderately critical
* Exploitable from: Remote
* Vulnerability: Cross Site Scripting

The Date module provides a date CCK field that can be added to any content
type. The Date Tools module that is bundled with Date module does not  properly
escape user input when displaying labels for fields on a content  type. A
malicious user with the 'use date tools' permission of the Date Tools  sub-
module, or the 'administer content types' permission could attempt a  cross site
scripting (XSS) attack when creating a new content type,  leading to the
user gaining full administrative access.

ChangeLog:

* Wed Jul 29 2009 Jon Ciesla  - 6.x.2.3-0
- Update to new version.
- Fix for DRUPAL-SA-CONTRIB-2009-046.
* Fri Jul 24 2009 Fedora Release Engineering  - 6.x.2.0-2.rc4.2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update drupal-date' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8184

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8184 (drupal-date)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"drupal-date", rpm:"drupal-date~6.x.2.3~0.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
