# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7750 (mediawiki)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64409);
 script_cve_id("CVE-2008-5249", "CVE-2008-5250", "CVE-2008-5252", "CVE-2008-5687", "CVE-2008-5688");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-7750 (mediawiki)";
 script_name(name);

 desc = "The remote host is missing an update to mediawiki
announced via advisory FEDORA-2009-7750.

Update Information:

This update upgrades mediawiki code to 1.15.1 and fixes some path references.
Upstream comments:  This is a security and bugfix release of MediaWiki 1.15.1
and 1.14.1.    A cross-site scripting (XSS) vulnerability was discovered. Only
versions 1.14.0, 1.15.0 and release candidates for those releases are affected.

ChangeLog:

* Mon Jul 13 2009 Axel Thimm  - 1.15.1-48
- Update to 1.15.1 (Fixes XSS vulnerability).
* Sat Jul 11 2009 Axel Thimm  - 1.15.0-47
- Fix api.php breakage.
* Sat Jun 13 2009 Axel Thimm  - 1.15.0-46
- Update to 1.15.0.
* Thu Apr 16 2009 S390x secondary arch maintainer 
- ExcludeArch sparc64, s390, s390x as we don't have OCaml on those archs
(added sparc64 per request from the sparc maintainer)
* Sat Feb 28 2009 Axel Thimm  - 1.14.0-45
- Update to 1.14.0.

References:

[ 1 ] Bug #484855 - mediawiki api.php has bad path
https://bugzilla.redhat.com/show_bug.cgi?id=484855
[ 2 ] Bug #494362 - maintenance scripts fail
https://bugzilla.redhat.com/show_bug.cgi?id=494362
[ 3 ] Bug #494880 - Uploading fails
https://bugzilla.redhat.com/show_bug.cgi?id=494880

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update mediawiki' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7750

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-7750 (mediawiki)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"mediawiki", rpm:"mediawiki~1.15.1~48.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki-math", rpm:"mediawiki-math~1.15.1~48.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki-nomath", rpm:"mediawiki-nomath~1.15.1~48.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mediawiki-debuginfo", rpm:"mediawiki-debuginfo~1.15.1~48.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
