# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7724 (libtiff)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64406);
 script_cve_id("CVE-2009-2347", "CVE-2009-2285");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-7724 (libtiff)";
 script_name(name);

 desc = "The remote host is missing an update to libtiff
announced via advisory FEDORA-2009-7724.

Update Information:

CVE-2009-2347 libtiff: integer overflows in various inter-color spaces
conversion tools (crash, ACE)    Not the same as last week's libtiff security
issue ...

ChangeLog:

* Mon Jul 13 2009 Tom Lane  3.8.2-14
- Fix buffer overrun risks caused by unchecked integer overflow (CVE-2009-2347)
Related: #510041
* Wed Jul  1 2009 Tom Lane  3.8.2-13
- Fix some more LZW decoding vulnerabilities (CVE-2009-2285)

Related: #507465
- Update upstream URL

References:

[ 1 ] Bug #510041 - EMBARGOED CVE-2009-2347 libtiff: integer overflows in various inter-color spaces conversion tools (crash, ACE)
https://bugzilla.redhat.com/show_bug.cgi?id=510041

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libtiff' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7724

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-7724 (libtiff)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libtiff", rpm:"libtiff~3.8.2~14.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-devel", rpm:"libtiff-devel~3.8.2~14.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-static", rpm:"libtiff-static~3.8.2~14.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtiff-debuginfo", rpm:"libtiff-debuginfo~3.8.2~14.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
