# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7680 (perl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64402);
 script_cve_id("CVE-2009-1391", "CVE-2008-2827", "CVE-2007-4829");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-7680 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory FEDORA-2009-7680.

Update Information:

This security update fixes an off-by-one overflow in Compress::Raw::Zlib
(CVE-2009-1391)  Moreover, it contains a subtle change to the configuration that
does not affect the Perl interpreter itself, but fixes the propagation of the
chosen options to the modules.  For example, a rebuild of perl-Wx against
perl-5.10.0-73 will fix bug 508496.

ChangeLog:

* Tue Jul  7 2009 Stepan Kasal  - 4:5.10.0-73
- re-enable tests
* Tue Jul  7 2009 Stepan Kasal  - 4:5.10.0-72
- move -DPERL_USE_SAFE_PUTENV to ccflags (#508496)
* Mon Jun  8 2009 Marcela Malov  - 4:5.10.0-71
- #504386 update of Compress::Raw::Zlib 2.020
* Thu Jun  4 2009 Marcela Malov  - 4:5.10.0-70
- update File::Spec (PathTools) to 3.30
* Wed Jun  3 2009 Stepan Kasal  - 4:5.10.0-69
- fix #221113, $! wrongly set when EOF is reached

References:

[ 1 ] Bug #504386 - Buffer overflow in Compress::Raw::Zlib
https://bugzilla.redhat.com/show_bug.cgi?id=504386
[ 2 ] Bug #508496 - Perl: symbol lookup error: .../Wx.so: undefined symbol: Perl_Guse_safe_putenv_ptr
https://bugzilla.redhat.com/show_bug.cgi?id=508496

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update perl' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7680

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-7680 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl", rpm:"perl~5.10.0~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Archive-Extract", rpm:"perl-Archive-Extract~0.30~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Archive-Tar", rpm:"perl-Archive-Tar~1.46~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-CPAN", rpm:"perl-CPAN~1.9205~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-CPANPLUS", rpm:"perl-CPANPLUS~0.84~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Compress-Raw", rpm:"perl-Compress-Raw~Zlib~2.008", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Compress-Zlib", rpm:"perl-Compress-Zlib~2.008~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Digest-SHA", rpm:"perl-Digest-SHA~5.47~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-CBuilder", rpm:"perl-ExtUtils-CBuilder~0.24~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-Embed", rpm:"perl-ExtUtils-Embed~1.28~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-MakeMaker", rpm:"perl-ExtUtils-MakeMaker~6.36~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-ParseXS", rpm:"perl-ExtUtils-ParseXS~2.18~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-File-Fetch", rpm:"perl-File-Fetch~0.18~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IO-Compress", rpm:"perl-IO-Compress~Base~2.008", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IO-Compress", rpm:"perl-IO-Compress~Zlib~2.008", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IO-Zlib", rpm:"perl-IO-Zlib~1.07~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IPC-Cmd", rpm:"perl-IPC-Cmd~0.42~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Locale-Maketext", rpm:"perl-Locale-Maketext~Simple~0.18", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Log-Message", rpm:"perl-Log-Message~0.01~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Log-Message", rpm:"perl-Log-Message~Simple~0.04", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Build", rpm:"perl-Module-Build~0.3200~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-CoreList", rpm:"perl-Module-CoreList~2.17~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Load", rpm:"perl-Module-Load~0.12~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Load", rpm:"perl-Module-Load~Conditional~0.30", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Loaded", rpm:"perl-Module-Loaded~0.01~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Pluggable", rpm:"perl-Module-Pluggable~3.60~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Object-Accessor", rpm:"perl-Object-Accessor~0.32~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Package-Constants", rpm:"perl-Package-Constants~0.01~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Params-Check", rpm:"perl-Params-Check~0.26~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Pod-Escapes", rpm:"perl-Pod-Escapes~1.04~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Pod-Simple", rpm:"perl-Pod-Simple~3.07~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Term-UI", rpm:"perl-Term-UI~0.18~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Test-Harness", rpm:"perl-Test-Harness~3.16~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Test-Simple", rpm:"perl-Test-Simple~0.86~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Time-Piece", rpm:"perl-Time-Piece~1.12~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-core", rpm:"perl-core~5.10.0~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-devel", rpm:"perl-devel~5.10.0~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-libs", rpm:"perl-libs~5.10.0~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-suidperl", rpm:"perl-suidperl~5.10.0~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-version", rpm:"perl-version~0.74~73.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-debuginfo", rpm:"perl-debuginfo~5.10.0~73.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
