# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7614 (seamonkey)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64400);
 script_cve_id("CVE-2009-2210", "CVE-2009-1841", "CVE-2009-1836", "CVE-2009-1838", "CVE-2009-1835", "CVE-2009-1832", "CVE-2009-1311", "CVE-2009-1307");
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-7614 (seamonkey)";
 script_name(name);

 desc = "The remote host is missing an update to seamonkey
announced via advisory FEDORA-2009-7614.

Update Information:

Update to upstream version 1.1.17, fixing multiple security flaws:
http://www.mozilla.org/security/known-
vulnerabilities/seamonkey11.html#seamonkey1.1.17

ChangeLog:

* Fri Jul 10 2009 Martin Stransky  1.1.17-1
- Update to 1.1.17
* Thu Jun 18 2009 Kai Engert  1.1.16-1.11.1
- fix categories in desktop files
* Thu May  7 2009 Kai Engert  1.1.16-1
- Update to 1.1.16
* Wed May  6 2009 Martin Stransky  1.1.15-4
- build with -fno-strict-aliasing (#468415)

References:

[ 1 ] Bug #507812 - CVE-2009-2210 Thunderbird mail crash
https://bugzilla.redhat.com/show_bug.cgi?id=507812
[ 2 ] Bug #503583 - CVE-2009-1841 Firefox JavaScript arbitrary code execution
https://bugzilla.redhat.com/show_bug.cgi?id=503583
[ 3 ] Bug #503578 - CVE-2009-1836 Firefox SSL tampering via non-200 responses to proxy CONNECT requests
https://bugzilla.redhat.com/show_bug.cgi?id=503578
[ 4 ] Bug #503580 - CVE-2009-1838 Firefox arbitrary code execution flaw
https://bugzilla.redhat.com/show_bug.cgi?id=503580
[ 5 ] Bug #503576 - CVE-2009-1835 Firefox Arbitrary domain cookie access by local file: resources
https://bugzilla.redhat.com/show_bug.cgi?id=503576
[ 6 ] Bug #503569 - CVE-2009-1832 Firefox double frame construction flaw
https://bugzilla.redhat.com/show_bug.cgi?id=503569
[ 7 ] Bug #496271 - CVE-2009-1311 Firefox POST data sent to wrong site when saving web page with embedded frame
https://bugzilla.redhat.com/show_bug.cgi?id=496271
[ 8 ] Bug #496263 - CVE-2009-1307 Firefox Same-origin violations when Adobe Flash loaded via view-source: protocol
https://bugzilla.redhat.com/show_bug.cgi?id=496263

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update seamonkey' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7614

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-7614 (seamonkey)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"seamonkey", rpm:"seamonkey~1.1.17~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"seamonkey-debuginfo", rpm:"seamonkey-debuginfo~1.1.17~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
