# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7491 (ocaml-camlimages)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64858);
 script_cve_id("CVE-2009-2295");
 script_version ("$");
 script_name("Fedora Core 10 FEDORA-2009-7491 (ocaml-camlimages)");

 desc = "The remote host is missing an update to ocaml-camlimages
announced via advisory FEDORA-2009-7491.

ChangeLog:

* Fri Jul  3 2009 Richard W.M. Jones  - 3.0.1-3.fc10.2
- ocaml-camlimages: PNG reader multiple integer overflows
(CVE 2009-2295 / RHBZ#509531).

References:

[ 1 ] Bug #509531 - CVE-2009-2295 ocaml-camlimages: PNG reader multiple integer overflows (oCERT-2009-009)
https://bugzilla.redhat.com/show_bug.cgi?id=509531

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ocaml-camlimages' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7491

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-7491 (ocaml-camlimages)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ocaml-camlimages", rpm:"ocaml-camlimages~3.0.1~3.fc10.2", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ocaml-camlimages-devel", rpm:"ocaml-camlimages-devel~3.0.1~3.fc10.2", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
