# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7435 (perl-IO-Socket-SSL)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64403);
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-7435 (perl-IO-Socket-SSL)";
 script_name(name);

 desc = "The remote host is missing an update to perl-IO-Socket-SSL
announced via advisory FEDORA-2009-7435.

Update Information:

This update to version 1.26 fixes an issue where only the prefix of the hostname
was checked if there was no wildcard present, so for example www.example.org
would match a certificate starting with www.exam.

ChangeLog:

* Sat Jul  4 2009 Paul Howarth  - 1.26-1
- Update to 1.26 (verify_hostname_of_cert matched only the prefix for the
hostname when no wildcard was given, e.g. www.example.org matched against a
certificate with name www.exam in it)
* Fri Jul  3 2009 Paul Howarth  - 1.25-1
- Update to 1.25 (fix t/nonblock.t for OS X 10.5 - CPAN RT#47240)

References:

[ 1 ] Bug #509819 - perl-IO-Socket-SSL: incorrect checking of certificate hostnames
https://bugzilla.redhat.com/show_bug.cgi?id=509819

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update perl-IO-Socket-SSL' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7435

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-7435 (perl-IO-Socket-SSL)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl-IO-Socket", rpm:"perl-IO-Socket~SSL~1.26", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
