# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-7415 (pidgin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64355);
 script_cve_id("CVE-2009-1889");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-7415 (pidgin)";
 script_name(name);

 desc = "The remote host is missing an update to pidgin
announced via advisory FEDORA-2009-7415.

Update Information:

Several important bug fixes:  - More fixes for Yahoo protocol 16  - MSN,
MySpace, XMPP  - CVE-2009-1889

ChangeLog:

* Sun Jun 28 2009 Warren Togami  2.5.8-1
- 2.5.8 with several important bug fixes
* Mon Jun 22 2009 Warren Togami  2.5.7-2
- glib2 compat with RHEL-4
* Sat Jun 20 2009 Warren Togami  2.5.7-1
- 2.5.7 with Yahoo Protocol 16 support
* Wed May 20 2009 Stu Tomlinson  2.5.6-1
- 2.5.6
* Mon Apr 20 2009 Warren Togami  2.5.5-3
- F12+ removed krb4

References:

[ 1 ] Bug #508738 - CVE-2009-1889 pidgin: DoS via specially-crafted ICQWebMessage
https://bugzilla.redhat.com/show_bug.cgi?id=508738

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update pidgin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-7415

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-7415 (pidgin)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"finch", rpm:"finch~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"finch-devel", rpm:"finch-devel~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-devel", rpm:"libpurple-devel~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-perl", rpm:"libpurple-perl~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple-tcl", rpm:"libpurple-tcl~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin", rpm:"pidgin~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-devel", rpm:"pidgin-devel~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-docs", rpm:"pidgin-docs~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-perl", rpm:"pidgin-perl~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"pidgin-debuginfo", rpm:"pidgin-debuginfo~2.5.8~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
