# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6839 (git)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64292);
 script_cve_id("CVE-2009-2108");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-6839 (git)";
 script_name(name);

 desc = "The remote host is missing an update to git
announced via advisory FEDORA-2009-6839.

Update Information:

This update fixes a Denial of Service vulnerability in git-daemon.  It also
fixes minor issues when using git-cvsimport and the formatting of the git-daemon
xinetd service description.

ChangeLog:

* Fri Jun 19 2009 Todd Zullinger  - 1.6.0.6-4
- Fix git-daemon hang on invalid input (CVE-2009-2108, bug 505761)
- Ignore Branches output from cvsps-2.2b1 (bug 490602)
- Escape newline in git-daemon xinetd description (bug 502393)

References:

[ 1 ] Bug #505761 - CVE-2009-2108 git daemon Denial of Service with unknown extra arg information
https://bugzilla.redhat.com/show_bug.cgi?id=505761
[ 2 ] Bug #502393 - git-daemon's description is an incomplete sentence
https://bugzilla.redhat.com/show_bug.cgi?id=502393
[ 3 ] Bug #490602 - git-cvsimport got noisy
https://bugzilla.redhat.com/show_bug.cgi?id=490602

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update git' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6839

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6839 (git)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"emacs-git", rpm:"emacs-git~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git", rpm:"git~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-all", rpm:"git-all~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-arch", rpm:"git-arch~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-cvs", rpm:"git-cvs~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-daemon", rpm:"git-daemon~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-email", rpm:"git-email~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-gui", rpm:"git-gui~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-svn", rpm:"git-svn~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gitk", rpm:"gitk~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gitweb", rpm:"gitweb~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Git", rpm:"perl-Git~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"git-debuginfo", rpm:"git-debuginfo~1.6.0.6~4.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
