# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6531 (libpng)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64240);
 script_cve_id("CVE-2009-2042", "CVE-2009-0040");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-6531 (libpng)";
 script_name(name);

 desc = "The remote host is missing an update to libpng
announced via advisory FEDORA-2009-6531.

Libpng should be installed if you need to manipulate PNG format image
files.

Update Information:

Update to libpng 1.2.37, to fix CVE-2009-2042.  This is a pretty low-risk issue,
but it's been classified as a security issue...

ChangeLog:

* Sat Jun 13 2009 Tom Lane  2:1.2.37-1
- Update to libpng 1.2.37, to fix CVE-2009-2042
Related: #504782

References:

[ 1 ] Bug #504782 - libpng: Interlaced Images Information Disclosure Vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=504782

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libpng' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6531

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-6531 (libpng)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libpng", rpm:"libpng~1.2.37~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-devel", rpm:"libpng-devel~1.2.37~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-static", rpm:"libpng-static~1.2.37~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpng-debuginfo", rpm:"libpng-debuginfo~1.2.37~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
