# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-6121 (icu)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64226);
 script_cve_id("CVE-2009-0153");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-6121 (icu)";
 script_name(name);

 desc = "The remote host is missing an update to icu
announced via advisory FEDORA-2009-6121.


CVE-2009-0153 Handle illegal sequences consistently

ChangeLog:

* Thu Jun 11 2009 Caolan McNamara  - 3.8.1-9
- Resolves: rhbz#505368 CVE-2009-0153 Handle illegal sequences consistently
* Tue Aug 26 2008 Caolan McNamara  - 3.8.1-8
- Resolves: rhbz#459698 drop Malayalam patches. Note test with
multiple fonts and not just Lohit Malayalam before filing bugs against icu
wrt. Malayalam rendering.

References:

[ 1 ] Bug #503071 - CVE-2009-0153 icu: XSS vulnerability due to improper invalid byte sequence handling
https://bugzilla.redhat.com/show_bug.cgi?id=503071

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update icu' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-6121

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-6121 (icu)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"icu", rpm:"icu~3.8.1~9.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libicu", rpm:"libicu~3.8.1~9.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libicu-devel", rpm:"libicu-devel~3.8.1~9.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libicu-doc", rpm:"libicu-doc~3.8.1~9.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"icu-debuginfo", rpm:"icu-debuginfo~3.8.1~9.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
