# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5674 (ntp)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64225);
 script_cve_id("CVE-2009-1252");
 script_version ("$");
 name = "Fedora Core 11 FEDORA-2009-5674 (ntp)";
 script_name(name);

 desc = "The remote host is missing an update to ntp
announced via advisory FEDORA-2009-5674.

Update Information:

This update fixes a denial of service issue if autokey is enabled (default is
disabled).

ChangeLog:

* Thu May 28 2009 Miroslav Lichvar  4.2.4p7-2
- fix frequency calculation when starting with no drift file
- reduce phase adjustments beyond Allan intercept in daemon PLL
* Tue May 19 2009 Miroslav Lichvar  4.2.4p7-1
- update to 4.2.4p7 (CVE-2009-1252)
- improve PLL response when kernel discipline is disabled
- don't log STA_MODE changes
- enable nanokernel support
- allow minpoll 3
- increase memlock limit
- move html documentation to -doc subpackage (#492444)

References:

[ 1 ] Bug #499694 - CVE-2009-1252 ntp: remote arbitrary code execution vulnerability if autokeys is enabled
https://bugzilla.redhat.com/show_bug.cgi?id=499694

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ntp' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5674

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 11 FEDORA-2009-5674 (ntp)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ntp", rpm:"ntp~4.2.4p7~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-perl", rpm:"ntp-perl~4.2.4p7~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntpdate", rpm:"ntpdate~4.2.4p7~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-debuginfo", rpm:"ntp-debuginfo~4.2.4p7~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntp-doc", rpm:"ntp-doc~4.2.4p7~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
