# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-5190 (nsd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64027);
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-5190 (nsd)";
 script_name(name);

 desc = "The remote host is missing an update to nsd
announced via advisory FEDORA-2009-5190.

A one-byte overflow bug allows a carefully crafted exploit
to bring down your DNS server. It is highly unlikely that this
one byte overflow can lead to other (system) exploits.

http://www.nlnetlabs.nl/publications/NSD_vulnerability_announcement.html

ChangeLog:

* Mon May 18 2009 Paul Wouters  - 3.2.2-1
- Upgraded to 3.2.2 security release
http://www.nlnetlabs.nl/publications/NSD_vulnerability_announcement.html
- Removed obsoleted options --enable-plugins --enable-mmap

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update nsd' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-5190

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-5190 (nsd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"nsd", rpm:"nsd~3.2.2~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"nsd-debuginfo", rpm:"nsd-debuginfo~3.2.2~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
