# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2883 (ghostscript)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63656);
 script_cve_id("CVE-2009-0583", "CVE-2009-0584");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2009-2883 (ghostscript)";
 script_name(name);

 desc = "The remote host is missing an update to ghostscript
announced via advisory FEDORA-2009-2883.

Update Information:

Security update for integer overflows (CVE-2009-0583) and upper bounds checks
(CVE-2009-0584) in the ICC profile handling.

ChangeLog:

* Fri Mar 20 2009 Tim Waugh  8.63-2
- Applied patch to fix CVE-2009-0583 (bug #487742) and CVE-2009-0584
(bug #487744).

References:

[ 1 ] Bug #487742 - CVE-2009-0583 ghostscript: Multiple integer overflows in the International Color Consortium Format Library
https://bugzilla.redhat.com/show_bug.cgi?id=487742
[ 2 ] Bug #487744 - CVE-2009-0584 ghostscript: Multiple insufficient upper-bounds checks on certain sizes in the International Color Consortium Format Library
https://bugzilla.redhat.com/show_bug.cgi?id=487744

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ghostscript' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2883

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-2883 (ghostscript)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ghostscript", rpm:"ghostscript~8.63~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.63~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-gtk", rpm:"ghostscript-gtk~8.63~2.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-debuginfo", rpm:"ghostscript-debuginfo~8.63~2.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
