# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2422 (firefox)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63529);
 script_cve_id("CVE-2009-0771", "CVE-2009-0772", "CVE-2009-0773", "CVE-2009-0774", "CVE-2009-0775", "CVE-2009-0776", "CVE-2009-0777");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-2422 (firefox)";
 script_name(name);

 desc = "The remote host is missing an update to firefox
announced via advisory FEDORA-2009-2422.

Update Information:

Update to the new upstream Firefox 3.0.7 / XULRunner 1.9.0.7 fixing multiple
security issues:
http://www.mozilla.org/security/known- vulnerabilities/firefox30.html#firefox3.0.7

This update also contains new builds of all applications depending
on Gecko libraries, built against the new version.

Note: after the updated packages are installed, Firefox must be
restarted for the update to take effect.

References:

[ 1 ] Bug #488272 - CVE-2009-0771 Firefox 3 Layout Engine Crashes
https://bugzilla.redhat.com/show_bug.cgi?id=488272
[ 2 ] Bug #488273 - CVE-2009-0772 Firefox 2 and 3 - Layout engine crashes
https://bugzilla.redhat.com/show_bug.cgi?id=488273
[ 3 ] Bug #488276 - CVE-2009-0773 Firefox 3 crashes in the JavaScript engine
https://bugzilla.redhat.com/show_bug.cgi?id=488276
[ 4 ] Bug #488283 - CVE-2009-0774 Firefox 2 and 3 crashes in the JavaScript engine
https://bugzilla.redhat.com/show_bug.cgi?id=488283
[ 5 ] Bug #488287 - CVE-2009-0775 Firefox XUL Linked Clones Double Free Vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=488287
[ 6 ] Bug #488290 - CVE-2009-0776 Firefox XML data theft via RDFXMLDataSource and cross-domain redirect
https://bugzilla.redhat.com/show_bug.cgi?id=488290
[ 7 ] Bug #488292 - CVE-2009-0777 Firefox URL spoofing with invisible control characters
https://bugzilla.redhat.com/show_bug.cgi?id=488292

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update firefox' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2422

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2422 (firefox)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"firefox", rpm:"firefox~3.0.7~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"firefox-debuginfo", rpm:"firefox-debuginfo~3.0.7~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
