# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1798 (wireshark)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63493);
 script_cve_id("CVE-2009-0599", "CVE-2009-0600");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1798 (wireshark)";
 script_name(name);

 desc = "The remote host is missing an update to wireshark
announced via advisory FEDORA-2009-1798.

Few minor security issues were fixed in new version of wireshark. Security-
related bugs in the Tektronix K12 and NetScreen file formats have been fixed.
http://www.wireshark.org/security/wnpa-sec-2009-01.html

ChangeLog:

* Tue Feb 17 2009 Radek Vokal  1.0.6-1
- add netdump2 support
- fix SELinux issues, remove pie patch
- upgrade to 1.0.6

References:

[ 1 ] Bug #485888 - CVE-2009-0599 wireshark: denial of service (application crash) via a malformed NetScreen snoop file.
https://bugzilla.redhat.com/show_bug.cgi?id=485888
[ 2 ] Bug #485889 - CVE-2009-0600 wireshark: denial of service (application crash) via a crafted Tektronix K12 text capture file
https://bugzilla.redhat.com/show_bug.cgi?id=485889

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update wireshark' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1798

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1798 (wireshark)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"wireshark", rpm:"wireshark~1.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-gnome", rpm:"wireshark-gnome~1.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"wireshark-debuginfo", rpm:"wireshark-debuginfo~1.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
