# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1518 (python-fedora)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63388);
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1518 (python-fedora)";
 script_name(name);

 desc = "The remote host is missing an update to python-fedora
announced via advisory FEDORA-2009-1518.

Update Information:

This release includes a bugfix to the
fedora.client.AccountSystem().verify_password() method.  verify_password() was
incorrectly returning True (username, password combination was correct) for any
input.  Although no known code is using this method to verify a user's account
with the Fedora Account System, the existence of the method and the fact that
anyone using this would be allowing users due to the bug makes this a high
priority bug to fix.

ChangeLog:

* Sun Feb  8 2009 Toshio Kuratomi  - 0.3.9-1
- New upstream with important bugfixes.
* Sat Nov 29 2008 Ignacio Vazquez-Abrams  - 0.3.8-2
- Rebuild for Python 2.6
* Thu Nov 20 2008 Toshio Kuratomi  - 0.3.8-1
- New upstream with pycurl client backend, more fas methods, and bodhi bugfix.
* Thu Oct 30 2008 Toshio Kuratomi  - 0.3.7-1
- New upstream has more complete pkgdb integration.

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update python-fedora' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1518

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1518 (python-fedora)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"python-fedora", rpm:"python-fedora~0.3.9~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
