# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1398 (xulrunner)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63378);
 script_cve_id("CVE-2009-0352", "CVE-2009-0354", "CVE-2009-0355", "CVE-2009-0358", "CVE-2009-0353", "CVE-2009-0356", "CVE-2009-0357");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1398 (xulrunner)";
 script_name(name);

 desc = "The remote host is missing an update to xulrunner
announced via advisory FEDORA-2009-1398.

XULRunner provides the XUL Runtime environment for Gecko applications.

Update Information:

Update to the new upstream Firefox 3.0.6 / XULRunner 1.9.0.6 fixing multiple
security issues:
http://www.mozilla.org/security/known-vulnerabilities/firefox30.html#firefox3.0.6

This update also contains new builds of all applications
depending on Gecko libraries, built against the new version,
including the latest google gadgets upstream release. See
http://code.google.com/p/google-gadgets-for-linux/source/browse/trunk/ChangeLog?spec=svn1087&r=1087
for details.

ChangeLog:

* Wed Feb  4 2009 Christopher Aillon  1.9.0.6-1
- Update to 1.9.0.6
* Thu Jan  8 2009 Martin Stransky  1.9.0.5-2
- Copied mozilla-config.h to stable include dir (#478445)
* Tue Dec 16 2008 Christopher Aillon  1.9.0.5-1
- Update to 1.9.0.5

References:

[ 1 ] Bug #483139 - CVE-2009-0352 Firefox layout crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=483139
[ 2 ] Bug #483142 - CVE-2009-0354 Firefox XSS using a chrome XBL method and window.eval
https://bugzilla.redhat.com/show_bug.cgi?id=483142
[ 3 ] Bug #483143 - CVE-2009-0355 Firefox local file stealing with SessionStore
https://bugzilla.redhat.com/show_bug.cgi?id=483143
[ 4 ] Bug #483150 - CVE-2009-0358 Firefox directives to not cache pages ignored
https://bugzilla.redhat.com/show_bug.cgi?id=483150
[ 5 ] Bug #483141 - CVE-2009-0353 Firefox javascript crashes with evidence of memory corruption
https://bugzilla.redhat.com/show_bug.cgi?id=483141
[ 6 ] Bug #483144 - CVE-2009-0356 Firefox Chrome privilege escalation via local .desktop files
https://bugzilla.redhat.com/show_bug.cgi?id=483144
[ 7 ] Bug #483145 - CVE-2009-0357 Firefox XMLHttpRequest allows reading HTTPOnly cookies
https://bugzilla.redhat.com/show_bug.cgi?id=483145

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xulrunner' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1398

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1398 (xulrunner)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xulrunner", rpm:"xulrunner~1.9.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel", rpm:"xulrunner-devel~1.9.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-devel-unstable", rpm:"xulrunner-devel-unstable~1.9.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-python", rpm:"xulrunner-python~1.9.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-python-devel", rpm:"xulrunner-python-devel~1.9.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xulrunner-debuginfo", rpm:"xulrunner-debuginfo~1.9.0.6~1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
