# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-13598 (phpldapadmin)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66579);
 script_version ("$Revision$");
 script_name("Fedora Core 11 FEDORA-2009-13598 (phpldapadmin)");

 desc = "The remote host is missing an update to phpldapadmin
announced via advisory FEDORA-2009-13598.

Update Information:

Upgrade to 1.2.0.4
A vulnerability has been discovered on phpLDAPadmin
version 1.1.x, which can be exploited by malicious people
to disclose sensitive information. See http://secunia.com/advisories/37848/
This update upgrades phpldapadmin to the latest version 1.2.0.4,
which is not affected.

ChangeLog:

* Wed Dec 23 2009 Dmitry Butskoy  - 1.2.0.4-1
- Upgrade to 1.2.0.4 . Fixes #549559
- Allow local IPv6 address by default

References:

[ 1 ] Bug #549559 - phpldapadmin: local file inclusion vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=549559

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update phpldapadmin' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-13598

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-13598 (phpldapadmin)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"phpldapadmin", rpm:"phpldapadmin~1.2.0.4~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
