# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-13181 (coreutils)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66560);
 script_cve_id("CVE-2009-4135");
 script_version ("$Revision$");
 script_name("Fedora Core 12 FEDORA-2009-13181 (coreutils)");

 desc = "The remote host is missing an update to coreutils
announced via advisory FEDORA-2009-13181.

Update Information:

CVE-2009-4135 : Unsafe temporary directory use in distcheck rule

ChangeLog:

* Fri Dec 11 2009 Ondrej Vasik  - 7.6-8
- CVE-2009-4135 : Unsafe temporary directory use in distcheck rule

References:

[ 1 ] Bug #545439 - CVE-2009-4135 coreutils: Unsafe temporary directory use in distcheck rule
https://bugzilla.redhat.com/show_bug.cgi?id=545439

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update coreutils' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-13181

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-13181 (coreutils)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"coreutils", rpm:"coreutils~7.6~8.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"coreutils-libs", rpm:"coreutils-libs~7.6~8.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"coreutils-debuginfo", rpm:"coreutils-debuginfo~7.6~8.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
