# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1213 (gstreamer-plugins-good)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63455);
 script_cve_id("CVE-2009-0386", "CVE-2009-0387");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1213 (gstreamer-plugins-good)";
 script_name(name);

 desc = "The remote host is missing an update to gstreamer-plugins-good
announced via advisory FEDORA-2009-1213.

ChangeLog:

* Mon Jan 26 2009 - Bastien Nocera  - 0.10.13-1
- Update to 0.10.13
- Update libv4l patch
* Wed Jan 14 2009 Warren Togami  0.10.11-4
- Bug #477877 Fix multilib conflict in -devel
- Bug #478449 Fix ladspa on lib64
* Wed Jan 14 2009 Lennart Poettering  0.10.11-3
- Bug #470000 Fix thread/memleak due to ref-loop
* Tue Jan 13 2009 Bastien Nocera  - 0.10.11-2
- Avoid pulsesink hang when PulseAudio disappears

References:

[ 1 ] Bug #481267 - gstreamer-plugins, gstreamer-plugins-good: heap-based buffer overflows / an array index out of bounds vulnerability while parsing malformed QuickTime media files
https://bugzilla.redhat.com/show_bug.cgi?id=481267
[ 2 ] Bug #483736 - CVE-2009-0386 gstreamer-plugins-good: heap-based buffer overflow while parsing malformed QuickTime media files via crafted Composition Time To Sample (aka ctts) atom data
https://bugzilla.redhat.com/show_bug.cgi?id=483736
[ 3 ] Bug #483737 - CVE-2009-0387 gstreamer-plugins-good: Array index error while parsing malformed QuickTime media files via crafted Sync Sample (aka stss) atom data
https://bugzilla.redhat.com/show_bug.cgi?id=483737

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gstreamer-plugins-good' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1213

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1213 (gstreamer-plugins-good)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gstreamer-plugins-good", rpm:"gstreamer-plugins-good~0.10.13~1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-plugins-good", rpm:"gstreamer-plugins-good~devel~0.10.13", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gstreamer-plugins-good", rpm:"gstreamer-plugins-good~debuginfo~0.10.13", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
