# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-1187 (gedit)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63294);
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-1187 (gedit)";
 script_name(name);

 desc = "The remote host is missing an update to gedit
announced via advisory FEDORA-2009-1187.

Update Information:

Untrusted search path vulnerability in gedit's Python module allows local users
to execute arbitrary code via a Trojan horse Python file in the current working
directory, related to an erroneous setting of sys.path by the PySys_SetArgv
function.

ChangeLog:

* Mon Jan 26 2009 Ray Strode  - 1:2.24.3-3
- Fix bug 481556 in a more functional way
* Mon Jan 26 2009 Ray Strode  - 1:2.24.3-2
- Fix up python plugin path to close up a security attack
vectors (bug 481556).
* Thu Jan 15 2009 Matthias Clasen  - 1:2.24.3-1
- Update to 2.24.3

References:

[ 1 ] Bug #481556 - gedit: untrusted python modules search path
https://bugzilla.redhat.com/show_bug.cgi?id=481556
http://bugzilla.gnome.org/show_bug.cgi?id=569214
http://www.nabble.com/Bug-484305%3A-bicyclerepair%3A-bike.vim-imports-untrusted-python-files-from-cwd-td18848099.html

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gedit' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-1187

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-1187 (gedit)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gedit", rpm:"gedit~2.24.3~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gedit-devel", rpm:"gedit-devel~2.24.3~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gedit-debuginfo", rpm:"gedit-debuginfo~2.24.3~3.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
