# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11499 (libsndfile)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66438);
 script_cve_id("CVE-2009-0186", "CVE-2009-1788", "CVE-2009-1791");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-11499 (libsndfile)");

 desc = "The remote host is missing an update to libsndfile
announced via advisory FEDORA-2009-11499.

Update Information:

Version 1.0.20 (2009-03-14)
* Fix potential heap overflow in VOC file parser
  (Tobias Klein, http://www.trapkit.de/).
Version 1.0.19 (2009-03-02)
* Fix for CVE-2009-0186 (Alin Rad Pop, Secunia Research).
* Huge number of minor bug fixes as a result of static analysis.
Version 1.0.18 (2009-02-07)
* Add Ogg/Vorbis support (thanks to John ffitch).
* Remove captive FLAC library.
* Many new features and bug fixes.

ChangeLog:

* Sat Nov 14 2009 Orcan Ogetbil  - 1.0.20-3
- Add FLAC/Ogg/Vorbis support (BR: libvorbis-devel)
- Make build verbose
- Remove rpath
- Fix ChangeLog encoding
- Move the big Changelog to the devel package

References:

[ 1 ] Bug #488361 - CVE-2009-0186 libsndfile: overflows may lead to execution of arbitrary code
https://bugzilla.redhat.com/show_bug.cgi?id=488361
[ 2 ] Bug #502657 - CVE-2009-1788 libsndfile VOC file heap based buffer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=502657
[ 3 ] Bug #502658 - CVE-2009-1791 libsndfile AIFF file heap based buffer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=502658

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libsndfile' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11499

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-11499 (libsndfile)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libsndfile", rpm:"libsndfile~1.0.20~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-devel", rpm:"libsndfile-devel~1.0.20~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsndfile-debuginfo", rpm:"libsndfile-debuginfo~1.0.20~3.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
