# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11314 (cups)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66430);
 script_cve_id("CVE-2009-2820", "CVE-2009-3553");
 script_version ("$Revision$");
 script_name("Fedora Core 12 FEDORA-2009-11314 (cups)");

 desc = "The remote host is missing an update to cups
announced via advisory FEDORA-2009-11314.

Update Information:

New release, including fix for XSS vulnerability in web interface
(CVE-2009-2820) and for improper reference counting in abstract file descriptors
handling interface (CVE-2009-3553).

ChangeLog:

* Thu Nov 19 2009 Tim Waugh  1:1.4.2-7
- Applied patch to fix CVE-2009-3553 (bug #530111, STR #3200).
* Tue Nov 17 2009 Tim Waugh  1:1.4.2-6
- Fixed display of current driver (bug #537182, STR #3418).
- Fixed out-of-memory handling when loading jobs (bug #538054,
STR #3407).
* Mon Nov 16 2009 Tim Waugh  1:1.4.2-5
- Fixed typo in admin web template (bug #537884, STR #3403).
- Reset SIGPIPE handler for child processes (bug #537886, STR #3399).
* Mon Nov 16 2009 Tim Waugh  1:1.4.2-4
- Upstream fix for GNU TLS error handling bug (bug #537883, STR #3381).
* Wed Nov 11 2009 Jiri Popelka  1:1.4.2-3
- Fixed lspp-patch to avoid memory leak (bug #536741).
* Tue Nov 10 2009 Tim Waugh  1:1.4.2-2
- Added explicit version dependency on cups-libs to cups-lpd
(bug #502205).
* Tue Nov 10 2009 Tim Waugh  1:1.4.2-1
- 1.4.2.  No longer need str3380, str3332, str3356, str3396 patches.
- Removed postscript.ppd.gz (bug #533371).
- Renumbered patches and sources.

References:

[ 1 ] Bug #529833 - CVE-2009-2820 cups: Several XSS flaws in forms processed by CUPS web interface
https://bugzilla.redhat.com/show_bug.cgi?id=529833
[ 2 ] Bug #530111 - CVE-2009-3553 cups: Use-after-free (crash) due improper reference counting in abstract file descriptors handling interface
https://bugzilla.redhat.com/show_bug.cgi?id=530111

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update cups' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11314

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 12 FEDORA-2009-11314 (cups)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"cups", rpm:"cups~1.4.2~7.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-devel", rpm:"cups-devel~1.4.2~7.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-libs", rpm:"cups-libs~1.4.2~7.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-lpd", rpm:"cups-lpd~1.4.2~7.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-php", rpm:"cups-php~1.4.2~7.fc12", rls:"FC12")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cups-debuginfo", rpm:"cups-debuginfo~1.4.2~7.fc12", rls:"FC12")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
