# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-11169 (libvorbis)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66249);
 script_cve_id("CVE-2009-3379", "CVE-2009-2663");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-11169 (libvorbis)");

 desc = "The remote host is missing an update to libvorbis
announced via advisory FEDORA-2009-11169.

Update Information:

CVE-2009-3379

ChangeLog:

* Mon Nov  9 2009 Jindrich Novy  1.2.0-7
- backport patches to fix CVE-2009-3379 (#531765) from upstream

References:

[ 1 ] Bug #531765 - CVE-2009-3379 libvorbis: security fixes mentioned in MFSA 2009-63
https://bugzilla.redhat.com/show_bug.cgi?id=531765

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libvorbis' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-11169

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-11169 (libvorbis)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libvorbis", rpm:"libvorbis~1.2.0~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvorbis-devel", rpm:"libvorbis-devel~1.2.0~7.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libvorbis-debuginfo", rpm:"libvorbis-debuginfo~1.2.0~7.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
