# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10694 (xpdf)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66094);
 script_cve_id("CVE-2009-1188", "CVE-2009-3603", "CVE-2009-3604", "CVE-2009-3606", "CVE-2009-3608", "CVE-2009-3609", "CVE-2009-3605", "CVE-2009-0799", "CVE-2009-0800", "CVE-2009-1179", "CVE-2009-1180", "CVE-2009-1181", "CVE-2009-1182", "CVE-2009-1183");
 script_version ("$Revision$");
 script_name("Fedora Core 10 FEDORA-2009-10694 (xpdf)");

 desc = "The remote host is missing an update to xpdf
announced via advisory FEDORA-2009-10694.

Update Information:

- apply xpdf-3.02pl4 security patch to fix:    CVE-2009-1188/CVE-2009-3603,
CVE-2009-3604, CVE-2009-3606,    CVE-2009-3608, CVE-2009-3609

ChangeLog:

* Fri Oct 16 2009 Tom spot Callaway  - 1:3.02-15
- apply xpdf-3.02pl4 security patch to fix:
CVE-2009-3603, CVE-2009-3604, CVE-2009-3605, CVE-2009-3606
CVE-2009-3608, CVE-2009-3609

References:

[ 1 ] Bug #495907 - CVE-2009-1188 xpdf/poppler: SplashBitmap integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=495907
[ 2 ] Bug #526911 - CVE-2009-3604 xpdf/poppler: Splash::drawImage integer overflow and missing allocation return value check
https://bugzilla.redhat.com/show_bug.cgi?id=526911
[ 3 ] Bug #526877 - CVE-2009-3606 xpdf/poppler: PSOutputDev::doImageL1Sep integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=526877
[ 4 ] Bug #526637 - CVE-2009-3608 xpdf/poppler: integer overflow in ObjectStream::ObjectStream (oCERT-2009-016)
https://bugzilla.redhat.com/show_bug.cgi?id=526637
[ 5 ] Bug #526893 - CVE-2009-3609 xpdf/poppler: ImageStream::ImageStream integer overflow
https://bugzilla.redhat.com/show_bug.cgi?id=526893

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xpdf' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10694

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10694 (xpdf)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~15.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-debuginfo", rpm:"xpdf-debuginfo~3.02~15.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
