# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10439 (dopewars)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66039);
 script_cve_id("CVE-2009-3591");
 script_version ("$Revision$");
 script_name("Fedora Core 11 FEDORA-2009-10439 (dopewars)");

 desc = "The remote host is missing an update to dopewars
announced via advisory FEDORA-2009-10439.

Update Information:

Fix DoS.

ChangeLog:

* Fri Oct  9 2009 Jussi Lehtola  - 1.5.12-8.1033svn
- Update to svn release to address security issues.

References:

[ 1 ] Bug #528081 - CVE-2009-3591 dopewars: DoS via REQUESTJET message with an invalid location
https://bugzilla.redhat.com/show_bug.cgi?id=528081

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update dopewars' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10439

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-10439 (dopewars)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"dopewars", rpm:"dopewars~1.5.12~8.1033svn.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dopewars-sdl", rpm:"dopewars-sdl~1.5.12~8.1033svn.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dopewars-debuginfo", rpm:"dopewars-debuginfo~1.5.12~8.1033svn.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
