# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0451 (bind)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63210);
 script_cve_id("CVE-2009-0025");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2009-0451 (bind)";
 script_name(name);

 desc = "The remote host is missing an update to bind
announced via advisory FEDORA-2009-0451.

Update Information:

Update to 9.5.1-P1 maintenance release which fixes CVE-2009-0025. This update
also address following issues:  - sample config file was outdated  - specifying
a fixed query source was broken

ChangeLog:

* Thu Jan  8 2009 Adam Tkac  32:9.5.1-1.P1
- 9.5.1-P1 release (CVE-2009-0025)
- patches merged
- bind-95-sdlz-include.patch
- bind-96-rh475120.patch

References:

[ 1 ] Bug #478984 - CVE-2009-0025 bind: DSA_do_verify() returns check issue
https://bugzilla.redhat.com/show_bug.cgi?id=478984

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update bind' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0451

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-0451 (bind)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"bind", rpm:"bind~9.5.1~1.P1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-chroot", rpm:"bind-chroot~9.5.1~1.P1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-devel", rpm:"bind-devel~9.5.1~1.P1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-libs", rpm:"bind-libs~9.5.1~1.P1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-sdb", rpm:"bind-sdb~9.5.1~1.P1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-utils", rpm:"bind-utils~9.5.1~1.P1.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bind-debuginfo", rpm:"bind-debuginfo~9.5.1~1.P1.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
