# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2008-11956 (libcdaudio)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63375);
 script_cve_id("CVE-2005-0706");
 script_version ("$");
 name = "Fedora Core 9 FEDORA-2008-11956 (libcdaudio)";
 script_name(name);

 desc = "The remote host is missing an update to libcdaudio
announced via advisory FEDORA-2008-11956.

libcdaudio is a library designed to provide functions to control
operation of a CD-ROM when playing audio CDs.  It also contains
functions for CDDB and CD Index lookup.

Update Information:

This update fixes a potential buffer overflow caused by large amount of CDDB
replies (CVE-2005-0706).

ChangeLog:

* Sat Dec 27 2008 Axel Thimm  - 0.99.12p2-11
- Fix CVE-2005-0706.
* Wed May 21 2008 Tom spot Callaway  - 0.99.12p2-10
- took COPYING out of doc (it is simply wrong)
- fixed license tag

References:

[ 1 ] Bug #470552 - CVE-2005-0706 grip,libcdaudio: buffer overflow caused by large amount of CDDB replies
https://bugzilla.redhat.com/show_bug.cgi?id=470552

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libcdaudio' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2008-11956

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2008-11956 (libcdaudio)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libcdaudio", rpm:"libcdaudio~0.99.12p2~11.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcdaudio-devel", rpm:"libcdaudio-devel~0.99.12p2~11.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libcdaudio-debuginfo", rpm:"libcdaudio-debuginfo~0.99.12p2~11.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
