# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2008-11736 (perl)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63089);
 script_cve_id("CVE-2007-4829");
 script_version ("$");
 name = "Fedora Core 10 FEDORA-2008-11736 (perl)";
 script_name(name);

 desc = "The remote host is missing an update to perl
announced via advisory FEDORA-2008-11736.

Update Information:

CVE-2007-4829 perl-Archive-Tar directory traversal flaws. Update of Pod::Simple
with better html support.

ChangeLog:

* Mon Dec 22 2008 Marcela Malov  - 4:5.10.0-52
- add missing XHTML.pm into Pod::Simple
- 295021 CVE-2007-4829 perl-Archive-Tar directory traversal flaws
- add another source for binary files, which test untaring links
* Fri Nov 28 2008 Tom spot Callaway  - 4:5.10.0-51
- to fix Fedora bz 473223, which is really perl bug #54186 (http://rt.perl.org/rt3//Public/Bug/Display.html?id=54186)
we apply Changes 33640, 33881, 33896, 33897
* Mon Nov 24 2008 Marcela Malov  - 4:5.10.0-50
- change summary according to RFC fix summary discussion at fedora-devel :)

References:

[ 1 ] Bug #295021 - CVE-2007-4829 perl-Archive-Tar directory traversal flaws
https://bugzilla.redhat.com/show_bug.cgi?id=295021

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update perl' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2008-11736

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2008-11736 (perl)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"perl", rpm:"perl~5.10.0~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Archive-Extract", rpm:"perl-Archive-Extract~0.24~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Archive-Tar", rpm:"perl-Archive-Tar~1.40~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-CPAN", rpm:"perl-CPAN~1.9205~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-CPANPLUS", rpm:"perl-CPANPLUS~0.84~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Compress-Raw", rpm:"perl-Compress-Raw~Zlib~2.008", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Compress-Zlib", rpm:"perl-Compress-Zlib~2.008~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Digest-SHA", rpm:"perl-Digest-SHA~5.45~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-CBuilder", rpm:"perl-ExtUtils-CBuilder~0.21~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-Embed", rpm:"perl-ExtUtils-Embed~1.28~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-MakeMaker", rpm:"perl-ExtUtils-MakeMaker~6.36~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-ExtUtils-ParseXS", rpm:"perl-ExtUtils-ParseXS~2.18~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-File-Fetch", rpm:"perl-File-Fetch~0.14~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IO-Compress", rpm:"perl-IO-Compress~Base~2.008", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IO-Compress", rpm:"perl-IO-Compress~Zlib~2.008", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IO-Zlib", rpm:"perl-IO-Zlib~1.07~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-IPC-Cmd", rpm:"perl-IPC-Cmd~0.40~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Locale-Maketext", rpm:"perl-Locale-Maketext~Simple~0.18", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Log-Message", rpm:"perl-Log-Message~0.01~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Log-Message", rpm:"perl-Log-Message~Simple~0.04", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Build", rpm:"perl-Module-Build~0.2808~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-CoreList", rpm:"perl-Module-CoreList~2.15~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Load", rpm:"perl-Module-Load~0.12~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Load", rpm:"perl-Module-Load~Conditional~0.24", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Loaded", rpm:"perl-Module-Loaded~0.01~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Module-Pluggable", rpm:"perl-Module-Pluggable~3.60~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Object-Accessor", rpm:"perl-Object-Accessor~0.32~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Package-Constants", rpm:"perl-Package-Constants~0.01~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Params-Check", rpm:"perl-Params-Check~0.26~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Pod-Escapes", rpm:"perl-Pod-Escapes~1.04~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Pod-Simple", rpm:"perl-Pod-Simple~3.07~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Term-UI", rpm:"perl-Term-UI~0.18~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Test-Harness", rpm:"perl-Test-Harness~3.12~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Test-Simple", rpm:"perl-Test-Simple~0.80~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-Time-Piece", rpm:"perl-Time-Piece~1.12~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-core", rpm:"perl-core~5.10.0~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-devel", rpm:"perl-devel~5.10.0~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-libs", rpm:"perl-libs~5.10.0~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-suidperl", rpm:"perl-suidperl~5.10.0~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-version", rpm:"perl-version~0.74~52.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"perl-debuginfo", rpm:"perl-debuginfo~5.10.0~52.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
