###############################################################################
# OpenVAS Vulnerability Test
# $Id: ejabberd_38003.nasl 6687 2010-02-08 22:29:56Z mime $
#
# ejabberd 'client2server' Message Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100487);
 script_bugtraq_id(38003);
 script_version ("1.0-$Revision: 6687 $");

 script_name("ejabberd 'client2server' Message Remote Denial of Service Vulnerability");

desc = "Overview:
The 'ejabberd' application is prone to a denial-of-service
vulnerability.

An attacker can exploit this issue to crash the affected application,
denying service to legitimate users.

Versions prior to ejabberd 2.1.3 are vulnerable; other versions may
also be affected.

Solution:
The vendor has released an update. Please see the references
for details.

References:
http://www.securityfocus.com/bid/38003
https://support.process-one.net/browse/EJAB/fixforversion/10453
http://www.process-one.net/en/ejabberd/

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if ejabberd version is < 2.1.3");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("ejabberd_detect.nasl");
 script_require_ports("Services/xmpp", 5222);
 exit(0);
}

include("version_func.inc");

xmpp_port = get_kb_item("Services/xmpp");
if(!xmpp_port)xmpp_port=5222;
if(!get_port_state(xmpp_port))exit(0);

if(!version = get_kb_item(string("xmpp/", xmpp_port, "/ejabberd")))exit(0);
if(!isnull(version)) {

  if(version_is_less(version: version, test_version: "2.1.3")) {
      security_warning(port:xmpp_port);
      exit(0);
  }

}

exit(0);

