#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#
# This script only checks if ports 4661-4663 are open. 
# The protocol is not documented, AFAIK. It was probably 'reverse engineered'
# for mldonkey (do you read OCAML?)
# I sniffed a eDonkey connection, but could not reproduce it. 
# There were some information on http://hitech.dk/donkeyprotocol.html
# but I could not use it.



if(description)
{
  script_id(11022);
  script_version ("$Revision: 4308 $");
 
  script_name("eDonkey/eMule detection");
 
  desc = "
eDonkey might be running on this port. This peer to peer 
software is used to share files.
1. This may be illegal.
2. You may have access to confidential files
3. It may eat too much bandwidth

* Note: This script only checks if ports 4661-4663 are open
*       and are unknown services.
Solution: disable it

Risk factor : Medium";

  script_description(desc);
 
  summary = "Detect eDonkey";
  script_summary(summary);
 
  script_category(ACT_GATHER_INFO);
 
  script_copyright("This script is Copyright (C) 2002 Michel Arboi");
  family = "Peer-To-Peer File Sharing";
  script_family(family);
  script_dependencie("find_service.nes");
  script_require_ports(4661, 4662, 4663);
 script_require_keys("Settings/ThoroughTests");

  exit(0);
}

include("misc_func.inc");
include('global_settings.inc');


if ( !thorough_tests ) exit(0);

for (port = 4661; port <= 4663; port = port + 1)
{
 if(get_port_state(port))
 {
 	kb = known_service(port:port);
	if(!kb || kb == "edonkey")
	{
	 soc = open_sock_tcp(port);
	 if(soc)
	 {
		# display(string("Open port = ", port, "\n"));
		security_warning(port);
		close(soc);
	 } 
	}
 }
}

# Looking for the mlDonkey web or telnet interface is useless:
# it only answers on localhost

exit(0);

