# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 956-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56209);
 script_bugtraq_id(16357);
 script_cve_id("CVE-2006-0353");
 script_version ("$");
 name = "Debian Security Advisory DSA 956-1 (lsh-utils)";
 script_name(name);

 desc = "The remote host is missing an update to lsh-utils
announced via advisory DSA 956-1.

Stefan Pfetzing discovered that lshd, a Secure Shell v2 (SSH2)
protocol server, leaks a couple of file descriptors, related to the
randomness generator, to user shells which are started by lshd.  A
local attacker can truncate the server's seed file, which may prevent
the server from starting, and with some more effort, maybe also crack
session keys.

After applying this update, you should remove the server's seed file
(/var/spool/lsh/yarrow-seed-file) and then regenerate it with
lsh-make-seed --server as root.

For security reasons, lsh-make-seed really needs to be run from the
console of the system you are running it on.  If you run lsh-make-seed
using a remote shell, the timing information lsh-make-seed uses for
its random seed creation is likely to be screwed.  If need be, you can
generate the random seed on a different system than that which it will
eventually be on, by installing the lsh-utils package and running
lsh-make-seed -o my-other-server-seed-file.  You may then transfer
the seed to the destination system as using a secure connection.

The old stable distribution (woody) may not be affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 2.0.1-3sarge1.

For the unstable distribution (sid) this problem has been fixed in
version 2.0.1cdbs-4.

We recommend that you upgrade your lsh-server package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20956-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 956-1 (lsh-utils)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"lsh-utils-doc", ver:"2.0.1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lsh-client", ver:"2.0.1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lsh-server", ver:"2.0.1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"lsh-utils", ver:"2.0.1-3sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
